

<?php $__env->startSection('title', 'Usuários'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Usuários</h1>
        <p class="content-subtitle">Gerenciamento de usuários do sistema</p>
    </div>
    <a href="<?php echo e(route('admin.usuarios.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Novo Usuário
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('admin.usuarios.index')); ?>" class="row g-3">
            <div class="col-md-3">
                <label for="categoria_id" class="form-label">Categoria</label>
                <select class="form-select" id="categoria_id" name="categoria_id">
                    <option value="">Todas</option>
                    <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($categoria->id); ?>" <?php echo e(request('categoria_id') == $categoria->id ? 'selected' : ''); ?>>
                            <?php echo e($categoria->nome); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label for="status" class="form-label">Status</label>
                <select class="form-select" id="status" name="status">
                    <option value="">Todos</option>
                    <option value="ativo" <?php echo e(request('status') === 'ativo' ? 'selected' : ''); ?>>Ativo</option>
                    <option value="inativo" <?php echo e(request('status') === 'inativo' ? 'selected' : ''); ?>>Inativo</option>
                </select>
            </div>
            <div class="col-md-4">
                <label for="search" class="form-label">Buscar</label>
                <input type="text" class="form-control" id="search" name="search" value="<?php echo e(request('search')); ?>" placeholder="Nome, email ou telefone">
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-search me-2"></i>Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Tabela -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Email</th>
                        <th>Telefone</th>
                        <th>Categoria</th>
                        <th>Status</th>
                        <th>Cadastro</th>
                        <th width="120">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <strong><?php echo e($usuario->nome); ?></strong>
                        </td>
                        <td><?php echo e($usuario->email); ?></td>
                        <td><?php echo e($usuario->telefone ?? '-'); ?></td>
                        <td>
                            <?php if($usuario->categoria_nome): ?>
                                <?php
                                    $badges = [
                                        'admin' => 'danger',
                                        'especialista' => 'primary',
                                        'coordenador' => 'info',
                                        'secretaria' => 'warning',
                                        'professor' => 'success',
                                        'aluno' => 'secondary',
                                        'gestao_pedagogica' => 'purple',
                                        'marketing' => 'pink',
                                    ];
                                    $badge = $badges[$usuario->categoria_slug ?? $usuario->role] ?? 'secondary';
                                ?>
                                <span class="badge bg-<?php echo e($badge); ?>"><?php echo e($usuario->categoria_nome); ?></span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Sem categoria</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($usuario->status === 'ativo' ? 'success' : 'secondary'); ?>">
                                <?php echo e(ucfirst($usuario->status)); ?>

                            </span>
                        </td>
                        <td><?php echo e($usuario->data_cadastro?->format('d/m/Y') ?? '-'); ?></td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?php echo e(route('admin.usuarios.show', $usuario->id)); ?>" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('admin.usuarios.edit', $usuario->id)); ?>" class="btn btn-outline-secondary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhum usuário encontrado</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if($usuarios->hasPages()): ?>
            <div class="mt-3">
                <?php echo e($usuarios->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/usuarios/index.blade.php ENDPATH**/ ?>