<?php if($leadsAguardando->count() > 0): ?>
    <?php $__currentLoopData = $leadsAguardando; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="lead-card border rounded p-3 bg-white" draggable="true" data-lead-id="<?php echo e($lead->id); ?>" style="cursor: move;">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <h6 class="fw-bold mb-1">
                        <i class="fas fa-grip-vertical me-2 text-muted"></i>
                        <?php echo e($lead->nome); ?>

                    </h6>
                    <small class="text-muted d-block">
                        <i class="fas fa-envelope me-1"></i>
                        <?php echo e($lead->email); ?>

                    </small>
                    <small class="text-muted d-block">
                        <i class="fas fa-phone me-1"></i>
                        <?php echo e($lead->telefone); ?>

                    </small>
                    <?php if($lead->data_cadastro): ?>
                    <small class="text-muted d-block">
                        <i class="fas fa-calendar me-1"></i>
                        <?php echo e(\Carbon\Carbon::parse($lead->data_cadastro)->format('d/m/Y H:i')); ?>

                    </small>
                    <?php endif; ?>
                </div>
                <div>
                    <?php
                        $statusDisplay = ucfirst(str_replace('_', ' ', $lead->etapa ?? 'novo'));
                        $badgeClass = 'bg-warning text-dark';
                        
                        switch($lead->etapa) {
                            case 'novo':
                                $badgeClass = 'bg-warning text-dark';
                                break;
                            case 'demo':
                                $badgeClass = 'bg-info text-white';
                                $statusDisplay = 'Em Negociação';
                                break;
                            case 'fechamento':
                                $badgeClass = 'bg-success';
                                $statusDisplay = 'Aprovada';
                                break;
                            case 'perdido':
                                $badgeClass = 'bg-danger';
                                $statusDisplay = 'Perdida';
                                break;
                        }
                    ?>
                    <span class="badge <?php echo e($badgeClass); ?> mb-2"><?php echo e($statusDisplay); ?></span>
                    <br>
                    <small class="text-muted">ID: <?php echo e($lead->id); ?></small>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
    <div class="text-center py-5 text-muted">
        <i class="fas fa-check-circle fa-3x mb-3"></i>
        <p>Nenhum lead aguardando.</p>
    </div>
<?php endif; ?>

<?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/leads/partials/leads-aguardando.blade.php ENDPATH**/ ?>