

<?php $__env->startSection('title', 'Gestão de Leads'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .lead-card {
        border: 1px solid #ddd;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 15px;
        background: white;
        transition: all 0.3s ease;
        cursor: move;
    }
    .lead-card:hover {
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        transform: translateY(-2px);
    }
    .lead-card.dragging {
        opacity: 0.5;
        transform: rotate(5deg);
    }
    .drop-zone {
        border: 2px dashed #ccc;
        border-radius: 8px;
        padding: 20px;
        text-align: center;
        background: #f8f9fa;
        transition: all 0.3s ease;
        min-height: 150px;
    }
    .drop-zone.drag-over {
        border-color: #28a745;
        background: #d4edda;
    }
    .especialista-card {
        border: 1px solid #e9ecef;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 10px;
        background: white;
        cursor: pointer;
    }
    .especialista-card:hover {
        border-color: #28a745;
        background: #f8fff9;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Gestão de Leads da Equipe</h1>
    <p class="content-subtitle">Distribua leads entre os especialistas da sua equipe</p>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if(session('error') || $errors->any()): ?>
    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>
        <?php echo e(session('error') ?? $errors->first()); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if(session('warning')): ?>
    <div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i><?php echo e(session('warning')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if($equipes->isNotEmpty()): ?>
    <?php $equipe = $equipes->first(); ?>
    
    <!-- Informações da Equipe -->
    <div class="alert alert-info mb-4">
        <h6><i class="fas fa-layer-group me-2"></i> Equipe: <?php echo e($equipe->nome); ?></h6>
        <small>Você está gerenciando os leads desta equipe.</small>
    </div>

    <!-- Estatísticas -->
    <div class="stats-grid mb-4">
        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                    <i class="fas fa-users"></i>
                </div>
            </div>
            <div class="stat-value"><?php echo e(number_format($statsLeads->total_leads ?? 0, 0, ',', '.')); ?></div>
            <div class="stat-label">Total de Leads</div>
        </div>
        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                    <i class="fas fa-clock"></i>
                </div>
            </div>
            <div class="stat-value"><?php echo e(number_format($statsLeads->aguardando_coordenador ?? 0, 0, ',', '.')); ?></div>
            <div class="stat-label">Aguardando</div>
        </div>
        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                    <i class="fas fa-phone"></i>
                </div>
            </div>
            <div class="stat-value"><?php echo e(number_format($statsLeads->contatado ?? 0, 0, ',', '.')); ?></div>
            <div class="stat-label">Contatado</div>
        </div>
        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                    <i class="fas fa-handshake"></i>
                </div>
            </div>
            <div class="stat-value"><?php echo e(number_format($statsLeads->em_negociacao ?? 0, 0, ',', '.')); ?></div>
            <div class="stat-label">Em Negociação</div>
        </div>
        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                    <i class="fas fa-check-circle"></i>
                </div>
            </div>
            <div class="stat-value"><?php echo e(number_format($statsLeads->aprovada ?? 0, 0, ',', '.')); ?></div>
            <div class="stat-label">Aprovada</div>
        </div>
        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon" style="background: #fee2e2; color: #ef4444;">
                    <i class="fas fa-times-circle"></i>
                </div>
            </div>
            <div class="stat-value"><?php echo e(number_format($statsLeads->rejeitada ?? 0, 0, ',', '.')); ?></div>
            <div class="stat-label">Rejeitada</div>
        </div>
    </div>

    <!-- Ações -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="d-flex justify-content-end">
                <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#distribuicaoAutomaticaModal">
                    <i class="fas fa-random me-2"></i>Distribuição Automática
                </button>
            </div>
        </div>
    </div>

    <!-- Área de Distribuição -->
    <div class="row">
        <!-- Leads Aguardando -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="fas fa-clock me-2"></i> Leads Aguardando Distribuição</h5>
                </div>
                <div class="card-body">
                    <div id="leads-aguardando">
                        <?php $__empty_1 = true; $__currentLoopData = $leadsAguardando; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="lead-card" draggable="true" data-lead-id="<?php echo e($lead->id); ?>">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h6 class="mb-1"><?php echo e($lead->nome); ?></h6>
                                        <small class="text-muted">
                                            <i class="fas fa-envelope me-1"></i><?php echo e($lead->email); ?><br>
                                            <i class="fas fa-phone me-1"></i><?php echo e($lead->telefone); ?><br>
                                            <i class="fas fa-calendar me-1"></i><?php echo e(\Carbon\Carbon::parse($lead->data_cadastro)->format('d/m/Y')); ?>

                                        </small>
                                    </div>
                                    <div class="text-end">
                                        <span class="badge bg-info">Aguardando Coordenador</span>
                                        <br>
                                        <button class="btn btn-sm btn-outline-success mt-1" onclick="distribuirManual(<?php echo e($lead->id); ?>)">
                                            <i class="fas fa-user-plus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-center text-muted py-5">
                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                <p>Nenhum lead aguardando distribuição</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Especialistas da Equipe -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="fas fa-user-tie me-2"></i> Especialistas da Equipe</h5>
                </div>
                <div class="card-body">
                    <div id="especialistas-destino" class="drop-zone">
                        <i class="fas fa-user-tie fa-2x mb-2 text-muted"></i>
                        <p class="text-muted">Arraste leads aqui para distribuir para especialistas</p>
                        
                        <div class="especialistas-list mt-3">
                            <?php $__empty_1 = true; $__currentLoopData = $especialistas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $especialista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="especialista-card" data-especialista-id="<?php echo e($especialista->id); ?>">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="mb-1"><?php echo e($especialista->nome); ?></h6>
                                            <small class="text-muted">
                                                <i class="fas fa-envelope me-1"></i><?php echo e($especialista->email); ?><br>
                                                <i class="fas fa-users me-1"></i><?php echo e($especialista->total_leads); ?> leads
                                            </small>
                                        </div>
                                        <div class="text-end">
                                            <span class="badge bg-success"><?php echo e($especialista->leads_aprovada); ?> aprovadas</span>
                                            <br>
                                            <small class="text-muted"><?php echo e($especialista->leads_negociacao); ?> em negociação</small>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="text-center text-muted py-3">
                                    <i class="fas fa-user-slash fa-2x mb-2"></i>
                                    <p>Nenhum especialista na equipe</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Modal Distribuição Automática -->
<div class="modal fade" id="distribuicaoAutomaticaModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Distribuição Automática de Leads</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?php echo e(route('coordenador.leads.distribuir-automatico')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Os leads aguardando coordenação serão distribuídos automaticamente entre os especialistas da sua equipe, 
                        seguindo a ordem de chegada.
                    </div>
                    
                    <div class="mb-3">
                        <h6>Especialistas da equipe:</h6>
                        <?php if($especialistas->isNotEmpty()): ?>
                            <ul class="list-group">
                                <?php $__currentLoopData = $especialistas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $esp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <?php echo e($esp->nome); ?>

                                        <span class="badge bg-primary rounded-pill"><?php echo e($esp->total_leads); ?> leads</span>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php else: ?>
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                Não há especialistas na equipe para receber leads.
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="mb-3">
                        <h6>Leads aguardando distribuição:</h6>
                        <span class="badge bg-info fs-6"><?php echo e($leadsAguardando->count()); ?> leads</span>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success" <?php echo e($especialistas->isEmpty() ? 'disabled' : ''); ?>>
                        Distribuir Automaticamente
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Distribuição Manual -->
<div class="modal fade" id="distribuicaoManualModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Distribuir Lead Manualmente</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?php echo e(route('coordenador.leads.distribuir-manual')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="lead_id" id="lead_id_manual">
                    
                    <div class="mb-3">
                        <label for="especialista_id" class="form-label">Selecione o especialista da equipe:</label>
                        <select class="form-select" name="especialista_id" id="especialista_id" required>
                            <option value="">Selecione um especialista...</option>
                            <?php $__currentLoopData = $especialistas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $esp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($esp->id); ?>">
                                    <?php echo e($esp->nome); ?> (<?php echo e($esp->total_leads); ?> leads)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success">Distribuir</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Drag and Drop functionality
document.addEventListener('DOMContentLoaded', function() {
    const leadCards = document.querySelectorAll('.lead-card');
    const dropZone = document.getElementById('especialistas-destino');
    
    // Configurar drag and drop para leads
    leadCards.forEach(card => {
        card.addEventListener('dragstart', function(e) {
            this.classList.add('dragging');
            e.dataTransfer.setData('text/plain', this.dataset.leadId);
        });
        
        card.addEventListener('dragend', function() {
            this.classList.remove('dragging');
        });
    });
    
    // Configurar zona de destino
    if (dropZone) {
        dropZone.addEventListener('dragover', function(e) {
            e.preventDefault();
            this.classList.add('drag-over');
        });
        
        dropZone.addEventListener('dragleave', function() {
            this.classList.remove('drag-over');
        });
        
        dropZone.addEventListener('drop', function(e) {
            e.preventDefault();
            this.classList.remove('drag-over');
            
            const leadId = e.dataTransfer.getData('text/plain');
            const especialistaCard = e.target.closest('.especialista-card');
            
            if (especialistaCard) {
                const especialistaId = especialistaCard.dataset.especialistaId;
                distribuirParaEspecialista(leadId, especialistaId);
            }
        });
    }
});

function distribuirManual(leadId) {
    document.getElementById('lead_id_manual').value = leadId;
    new bootstrap.Modal(document.getElementById('distribuicaoManualModal')).show();
}

function distribuirParaEspecialista(leadId, especialistaId) {
    // Criar formulário temporário para enviar via POST
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '<?php echo e(route("coordenador.leads.distribuir-manual")); ?>';
    form.style.display = 'none';
    
    const csrfInput = document.createElement('input');
    csrfInput.type = 'hidden';
    csrfInput.name = '_token';
    csrfInput.value = '<?php echo e(csrf_token()); ?>';
    
    const leadInput = document.createElement('input');
    leadInput.type = 'hidden';
    leadInput.name = 'lead_id';
    leadInput.value = leadId;
    
    const especialistaInput = document.createElement('input');
    especialistaInput.type = 'hidden';
    especialistaInput.name = 'especialista_id';
    especialistaInput.value = especialistaId;
    
    form.appendChild(csrfInput);
    form.appendChild(leadInput);
    form.appendChild(especialistaInput);
    
    document.body.appendChild(form);
    form.submit();
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.coordenador', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/coordenador/leads/index.blade.php ENDPATH**/ ?>