

<?php $__env->startSection('title', 'Nova Categoria'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.categorias.index')); ?>">Categorias</a></li>
            <li class="breadcrumb-item active">Nova</li>
        </ol>
    </nav>
    <h1 class="content-title">Nova Categoria</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="<?php echo e(route('admin.categorias.store')); ?>">
            <?php echo csrf_field(); ?>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="nome" class="form-label">Nome *</label>
                    <input type="text" class="form-control" id="nome" name="nome" value="<?php echo e(old('nome')); ?>" required>
                </div>
                <div class="col-md-6">
                    <label for="slug" class="form-label">Slug *</label>
                    <input type="text" class="form-control" id="slug" name="slug" value="<?php echo e(old('slug')); ?>" required>
                    <small class="text-muted">Ex: admin, especialista, coordenador</small>
                </div>
            </div>

            <div class="mb-3">
                <label for="descricao" class="form-label">Descrição</label>
                <textarea class="form-control" id="descricao" name="descricao" rows="3"><?php echo e(old('descricao')); ?></textarea>
            </div>

            <div class="mb-3">
                <label for="nivel_acesso" class="form-label">Nível de Acesso *</label>
                <input type="number" class="form-control" id="nivel_acesso" name="nivel_acesso" 
                       value="<?php echo e(old('nivel_acesso', 100)); ?>" min="1" max="1000" required>
                <small class="text-muted">Quanto menor, maior o nível de acesso (Admin = 10, Aluno = 300)</small>
            </div>

            <div class="text-end">
                <a href="<?php echo e(route('admin.categorias.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Categoria
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/categorias/create.blade.php ENDPATH**/ ?>