

<?php $__env->startSection('title', 'Vouchers'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Vouchers</h1>
        <p class="content-subtitle">Gerenciamento de cupons de desconto</p>
    </div>
    <a href="<?php echo e(route('admin.vouchers.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Novo Voucher
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Nome</th>
                        <th>Tipo</th>
                        <th>Desconto</th>
                        <th>Quantidade</th>
                        <th>Validade</th>
                        <th>Status</th>
                        <th width="120">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $voucher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><code><?php echo e($voucher->codigo); ?></code></td>
                        <td><?php echo e($voucher->nome ?? '-'); ?></td>
                        <td>
                            <span class="badge bg-info"><?php echo e(ucfirst($voucher->tipo)); ?></span>
                        </td>
                        <td>
                            <?php if($voucher->percentual_desconto): ?>
                                <?php echo e($voucher->percentual_desconto); ?>%
                            <?php elseif($voucher->valor_desconto): ?>
                                R$ <?php echo e(number_format($voucher->valor_desconto, 2, ',', '.')); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-secondary">
                                <?php echo e($voucher->quantidade_usada); ?>/<?php echo e($voucher->quantidade_total); ?>

                            </span>
                        </td>
                        <td>
                            <?php echo e($voucher->validade ? \Carbon\Carbon::parse($voucher->validade)->format('d/m/Y') : 'Sem limite'); ?>

                        </td>
                        <td>
                            <?php
                                $statusBadge = match($voucher->status) {
                                    'ativo' => 'success',
                                    'inativo' => 'secondary',
                                    'expirado' => 'danger',
                                    default => 'secondary',
                                };
                            ?>
                            <span class="badge bg-<?php echo e($statusBadge); ?>"><?php echo e(ucfirst($voucher->status)); ?></span>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?php echo e(route('admin.vouchers.show', $voucher->id)); ?>" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('admin.vouchers.edit', $voucher->id)); ?>" class="btn btn-outline-secondary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button type="button" class="btn btn-outline-<?php echo e($voucher->ativo ? 'warning' : 'success'); ?>" 
                                        onclick="toggleStatus(<?php echo e($voucher->id); ?>)" 
                                        title="<?php echo e($voucher->ativo ? 'Desativar' : 'Ativar'); ?>">
                                    <i class="fas fa-<?php echo e($voucher->ativo ? 'toggle-on' : 'toggle-off'); ?>"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhum voucher encontrado</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if($vouchers->hasPages()): ?>
            <div class="mt-3">
                <?php echo e($vouchers->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleStatus(id) {
    fetch(`/equipe/public/admin/vouchers/${id}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/vouchers/index.blade.php ENDPATH**/ ?>